<?php
include 'koneksi.php';

if (isset($_POST['edit'])) {
    $id_stok = mysqli_real_escape_string($conn, $_POST['id_stok']);
    $jumlah = mysqli_real_escape_string($conn, $_POST['jumlah']);

    // Validasi input
    if (empty($id_stok) || !isset($jumlah)) {
        echo "<script>alert('❌ Data tidak valid!'); window.location='stok.php';</script>";
        exit;
    }
    
    if ($jumlah < 0) {
        echo "<script>alert('❌ Jumlah stok tidak boleh negatif!'); window.location='stok.php';</script>";
        exit;
    }

    // Ambil data stok lama
    $query_old = "SELECT s.jumlah as jumlah_lama, o.nama_obat, o.kode_obat, o.satuan, g.nama_gudang 
                  FROM stok s
                  JOIN obat o ON s.id_obat = o.id_obat
                  JOIN gudang g ON s.id_gudang = g.id_gudang
                  WHERE s.id_stok = '$id_stok'";
    $result_old = mysqli_query($conn, $query_old);
    
    if (mysqli_num_rows($result_old) == 0) {
        echo "<script>alert('❌ Data stok tidak ditemukan!'); window.location='stok.php';</script>";
        exit;
    }
    
    $old_data = mysqli_fetch_assoc($result_old);
    $jumlah_lama = $old_data['jumlah_lama'];

    // Update stok
    $query = "UPDATE stok SET jumlah = '$jumlah' WHERE id_stok = '$id_stok'";
    
    if (mysqli_query($conn, $query)) {
        $selisih = $jumlah - $jumlah_lama;
        $status_perubahan = '';
        
        if ($selisih > 0) {
            $status_perubahan = "📈 Bertambah: +" . $selisih . " {$old_data['satuan']}";
        } elseif ($selisih < 0) {
            $status_perubahan = "📉 Berkurang: " . $selisih . " {$old_data['satuan']}";
        } else {
            $status_perubahan = "➖ Tidak ada perubahan";
        }
        
        echo "<script>
            alert('✓ Stok berhasil diperbarui!\\n\\n📦 Info:\\nObat: {$old_data['nama_obat']}\\nGudang: {$old_data['nama_gudang']}\\n\\nStok Lama: $jumlah_lama {$old_data['satuan']}\\nStok Baru: $jumlah {$old_data['satuan']}\\n\\n$status_perubahan');
            window.location='stok.php';
        </script>";
    } else {
        echo "<script>alert('❌ Gagal memperbarui stok: " . mysqli_error($conn) . "'); window.location='stok.php';</script>";
    }
}
?>